@extends('backend.master')
@section('title')
{{ @$data['title'] }}
@endsection
@section('content')
<div class="page-content">

    {{-- bradecrumb Area S t a r t --}}
    <div class="page-header">
        <div class="row">
            <div class="col-sm-6">
                <h4 class="bradecrumb-title mb-1">{{ $data['title'] }}</h1>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ ___('common.home') }}</a></li>
                    <li class="breadcrumb-item">{{ $data['title'] }}</li>
                </ol>
            </div>
        </div>
    </div>
    {{-- bradecrumb Area E n d --}}

    <!--  table content start -->
    <div class="table-content table-basic mt-20">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h4 class="mb-0">{{ ___('common.Property') }}</h4>
                @if (hasPermission('property_create'))
                <a href="{{ route('properties.create') }}" class="btn btn-lg ot-btn-primary">
                    <span><i class="fa-solid fa-plus"></i> </span>
                    <span class="">{{ ___('common.Add Property') }}</span>
                </a>
                @endif
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered user-table">
                        <thead class="thead">
                            <tr>
                                <th class="serial">{{ ___('common.sr_no.') }}</th>
                                <th class="purchase">{{ ___('common.name') }}</th>
                                <th class="purchase">{{ ___('common.Info') }}</th>
                                <th class="purchase">{{ ___('common.Particulars') }}</th>
                                <th class="purchase">{{ ___('common.Address') }}</th>
                                <th class="purchase">{{ ___('common.Type') }}</th>
                                <th class="purchase">{{ ___('common.status') }}</th>
                                @if (hasPermission('user_update') || hasPermission('user_delete'))
                                <th class="action">{{ ___('common.action') }}</th>
                                @endif
                            </tr>
                        </thead>
                        <tbody class="tbody">
                            @forelse ($data['property'] as $key => $row)
                            <tr id="row_{{ $row->id }}">
                                <td class="serial">{{ ++$key }}</td>
                                <td>
                                    <div class="">
                                        <a href="{{ route('admin.properties.details',[ $row->id, 'basicInfo']) }}">
                                            <div class="user-card">
                                                <div class="">
                                                    <img src="{{ @globalAsset($row->defaultImage->path) }}"
                                                        alt="{{ $row->name }}">
                                                </div>
                                                <div class="user-info">
                                                    <span class="tb-lead p-2">{{ $row->name }} </span>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                </td>
                                <td>
                                    <strong>{{$row->type==1?'Commercial':'Residential'}}</strong><br>
                                    <strong>{{ ___('common.Status') }}:</strong> {{$row->completion==1?'Completed':'Under Construction'}}<br>
                                    <strong>{{ ___('common.Unit') }}:</strong> {{$row->total_unit}}<br>
                                    <strong>{{ ___('common.Occupied') }}:</strong> {{$row->total_occupied}}<br>
                                    <strong>{{ ___('common.Rent') }}:</strong> {{$row->total_rent}}<br>
                                    <strong>{{ ___('common.Sell') }}:</strong> {{$row->total_sell}}
                                </td>
                                <td>
                                    <strong>{{ ___('common.Size') }}:</strong> {{$row->size}} {{ ___('common.sqft') }}<br>
                                    <strong>{{ ___('common.Dining Combined') }}:</strong> {{$row->dining_combined==1?'Yes':'No'}}<br>
                                    <strong>{{ ___('common.Bedroom') }}:</strong> {{$row->bedroom}}<br>
                                    <strong>{{ ___('common.Bathroom') }}:</strong> {{$row->bathroom}}<br>
                                    <strong>{{ ___('common.Rent Amount') }}:</strong> {{$row->rent_amount}}<br>
                                    @if ($row->flat_no)
                                    <strong>{{ ___('common.Flat No.') }}:</strong> {{$row->flat_no}}
                                    @endif
                                </td>
                                {{-- @dd($row->location) --}}
                                <td>
                                    <strong>{{ ___('common.Address') }}:</strong> {{ @$row->location->address}}<br>
                                    <strong>{{ ___('common.State') }}:</strong> {{ @$row->location->state->name}}<br>
                                    <strong>{{ ___('common.City') }}:</strong> {{ @$row->location->city->name}}<br>
                                    <strong>{{ ___('common.Post Code') }}:</strong> {{ @$row->location->post_code}}<br>
                                    <strong>{{ ___('common.Country') }}:</strong> {{ @$row->location->country->name}}
                                </td>
                                <td>
                                    <div>
                                        <span class="badge badge-pill {{$row->deal_type == 1 ? 'badge-basic-primary-text':'badge-basic-warning-text'}}">{{$row->deal_type == 1 ? 'Rent':'Sell'}}</span>
                                    </div>
                                </td>
                                <td>
                                    @if ($row->status == App\Enums\Status::ACTIVE)
                                    <span class="badge-basic-success-text">{{ ___('common.active') }}</span>
                                    @else
                                    <span class="badge-basic-danger-text">{{ ___('common.inactive') }}</span>
                                    @endif
                                </td>
                                @if (hasPermission('user_update') || hasPermission('user_delete'))
                                <td class="action">
                                    <div class="dropdown dropdown-action">
                                        <button type="button" class="btn-dropdown" data-bs-toggle="dropdown"
                                            aria-expanded="false">
                                            <i class="fa-solid fa-ellipsis"></i>
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu-end">
                                            {{-- @if (hasPermission('user_update')) --}}
                                            <li>
                                                <a class="dropdown-item" href="{{ route('admin.properties.details',[ $row->id, 'basicInfo']) }}">
                                                    <span class="icon mr-8"><i
                                                            class="fa-solid fa-eye"></i></span>
                                                    <span>{{ ___('common.view') }}</span>
                                                </a>
                                            </li>
                                            {{-- @endif --}}
                                            {{-- @if (hasPermission('user_update'))
                                            <li>
                                                <a class="dropdown-item" href="{{ route('users.edit', $row->id) }}">
                                                    <span class="icon mr-8"><i
                                                            class="fa-solid fa-pen-to-square"></i></span>
                                                    <span>{{ ___('common.edit') }}</span>
                                                </a>
                                            </li>
                                            @endif --}}
                                            @if (hasPermission('user_delete'))
                                            <li>
                                                <a class="dropdown-item" href="javascript:void(0);"
                                                    onclick="delete_row('users/delete', {{ $row->id }})">
                                                    <span class="icon mr-12"><i
                                                            class="fa-solid fa-trash-can"></i></span>
                                                    <span>{{ ___('common.delete') }}</span>
                                                </a>
                                            </li>
                                            @endif
                                        </ul>
                                    </div>

                                </td>
                                @endif
                            </tr>

                            @empty
                            <tr>
                                <td colspan="100%" class="text-center gray-color">
                                    <img src="{{ asset('images/no_data.svg') }}" alt="" class="mb-primary" width="100">
                                    <p class="mb-0 text-center">No data available</p>
                                    <p class="mb-0 text-center text-secondary font-size-90">
                                        Please add new entity regarding this table</p>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <!--  table end -->
                <!--  pagination start -->
                    <div class="ot-pagination pagination-content d-flex justify-content-end align-content-center py-3">
                        <nav aria-label="Page navigation example">
                            <ul class="pagination justify-content-between">
                                {!! $data['property']->links() !!}
                            </ul>
                        </nav>
                    </div>
                <!--  pagination end -->
            </div>
        </div>
    </div>
    <!--  table content end -->
</div>
@endsection


@push('script')
@include('backend.partials.delete-ajax')
@endpush
